#include ".\pythoninclude\Python.h"
#include "scripts.h"
#include "engine.h"
#include "helper_functions.h"

PyObject* scriptsdll_getgameobj(PyObject *self, PyObject *args)
{
	int playerid, id;
	GameObject* o;

	if (!PyArg_ParseTuple(args, "i", &playerid))
	{
		printf("\nError occured inside scriptsdll.getgameobject.\n Bad argument(s)?\n");
		return NULL;
	}
	o = Helper::Get_GameObject(playerid);
	id = Helper::Get_ID(o);
	return Py_BuildValue("i", id);
}

PyObject* scriptsdll_getplayerid(PyObject *self, PyObject *args)
{
	int playerid, id;
	GameObject* o;

	if (!PyArg_ParseTuple(args, "i", &id))
	{
		printf("\nError occured inside scriptsdll.getplayerid.\n Bad argument(s)?\n");
		return NULL;
	}
	o = Helper::Get_GameObject(id);
	playerid = Get_Player_ID(o);
	return Py_BuildValue("i", playerid);
}



PyObject* scriptsdll_getplayername(PyObject *self, PyObject *args)
{
	int id;
	const char* playername;
	GameObject* o;

	if (!PyArg_ParseTuple(args, "i", &id))
	{
		printf("\nError occured inside scriptsdll.getplayername.\n Bad argument(s)?\n");
		return NULL;
	}
	o = Helper::Get_GameObject(id);
	playername = Get_Player_Name(o);
	return Py_BuildValue("s", playername);
}

PyObject* scriptsdll_getplayernamebyid(PyObject *self, PyObject *args)
{
	int playerid;
	const char* playername;

	if (!PyArg_ParseTuple(args, "i", &playerid))
	{
		printf("\nError occured inside scriptsdll.getplayernamebyid.\n Bad argument(s)?\n");
		return NULL;
	}

	
	playername = Get_Player_Name_By_ID(playerid);
	return Py_BuildValue("s", playername);
}

PyCFunction* scriptsdll_changeteam(PyObject *self, PyObject *args)
{
	int id, team;

	if (!PyArg_ParseTuple(args, "ii", &id, &team))
	{
		printf("\nError occured inside scriptsdll.changeteam.\n Bad argument(s)?\n");
        return NULL;
	}
	Change_Team(Commands->Find_Object(id), team);
	Py_INCREF(Py_None);
	return (PyCFunction*)Py_None;
}

PyCFunction* scriptsdll_changeteambyid(PyObject *self, PyObject *args)
{
	int playerid, team;
	if (!PyArg_ParseTuple(args, "ii", &playerid, &team))
	{
		printf("\nError occured inside scriptsdll.changeteambyid.\n Bad argument(s)?\n");
        return NULL;
	}
	Change_Team_By_ID(playerid, team);
	Py_INCREF(Py_None);
	return (PyCFunction*)Py_None;
}

PyObject* scriptsdll_getplayercount(PyObject *self, PyObject *args)
{
	int playercount;
	
	playercount = Get_Player_Count();
	return Py_BuildValue("i", playercount);
}

PyObject* scriptsdll_getteamplayercount(PyObject *self, PyObject *args)
{
	int team, teamplayercount;

	if (!PyArg_ParseTuple(args, "i", &team))
	{
		printf("\nError occured inside scriptsdll.getteamplayercount.\n Bad argument(s)?\n");
		return NULL;
	}
	
	teamplayercount = Get_Team_Player_Count(team);
	return Py_BuildValue("i", teamplayercount);
}

PyObject* scriptsdll_getteam(PyObject *self, PyObject *args)
{
	int team, playerid;

	if (!PyArg_ParseTuple(args, "i", &playerid))
	{
		printf("\nError occured inside scriptsdll.getteam.\n Bad argument(s)?\n");
		return NULL;
	}
	
	team = Get_Team(playerid);
	return Py_BuildValue("i", team);
}

PyObject* scriptsdll_getrank(PyObject *self, PyObject *args)
{
	int rank, playerid;

	if (!PyArg_ParseTuple(args, "i", &playerid))
	{
		printf("\nError occured inside scriptsdll.getrank.\n Bad argument(s)?\n");
		return NULL;
	}
	
	rank = Get_Rank(playerid);
	return Py_BuildValue("i", rank);
}

PyObject* scriptsdll_getkills(PyObject *self, PyObject *args)
{
	int kills, playerid;

	if (!PyArg_ParseTuple(args, "i", &playerid))
	{
		printf("\nError occured inside scriptsdll.getkills.\n Bad argument(s)?\n");
		return NULL;
	}
	
	kills = Get_Kills(playerid);
	return Py_BuildValue("i", kills);
}

PyObject* scriptsdll_getdeaths(PyObject *self, PyObject *args)
{
	int deaths, playerid;

	if (!PyArg_ParseTuple(args, "i", &playerid))
	{
		printf("\nError occured inside scriptsdll.getdeaths.\n Bad argument(s)?\n");
		return NULL;
	}
	
	deaths = Get_Deaths(playerid);
	return Py_BuildValue("i", deaths);
}

PyObject* scriptsdll_getscore(PyObject *self, PyObject *args)
{
	int playerid;
	float score;

	if (!PyArg_ParseTuple(args, "i", &playerid))
	{
		printf("\nError occured inside scriptsdll.getscore.\n Bad argument(s)?\n");
		return NULL;
	}
	
	score = Get_Score(playerid);
	return Py_BuildValue("f", score);
}

PyObject* scriptsdll_getmoney(PyObject *self, PyObject *args)
{
	int playerid;
	float money;

	if (!PyArg_ParseTuple(args, "i", &playerid))
	{
		printf("\nError occured inside scriptsdll.getmoney.\n Bad argument(s)?\n");
		return NULL;
	}
	
	money = Get_Money(playerid);
	return Py_BuildValue("f", money);
}

PyObject* scriptsdll_getkd(PyObject *self, PyObject *args)
{
	int playerid;
	float kd;

	if (!PyArg_ParseTuple(args, "i", &playerid))
	{
		printf("\nError occured inside scriptsdll.getkd.\n Bad argument(s)?\n");
		return NULL;
	}
	
	kd = Get_Kill_To_Death_Ratio(playerid);
	return Py_BuildValue("f", kd);
}



PyObject* scriptsdll_getpartname(PyObject *self, PyObject *args)
{
	int id;
	const char* playername;

	if (!PyArg_ParseTuple(args, "s", &playername))
	{
		printf("\nError occured inside scriptsdll.getpartname.\n Bad argument(s)?\n");
		return NULL;
	}
	
	id = Helper::Get_ID(Get_Part_Name(playername));
	return Py_BuildValue("i", id);
}

PyObject* scriptsdll_getpartnames(PyObject *self, PyObject *args)
{
	int count;
	const char* playername;

	if (!PyArg_ParseTuple(args, "s", &playername))
	{
		printf("\nError occured inside scriptsdll.getpartnames.\n Bad argument(s)?\n");
		return NULL;
	}
	
	count = Get_Part_Names(playername);
	return Py_BuildValue("i", count);
}

PyObject* scriptsdll_getgameobjbyplayername(PyObject *self, PyObject *args)
{
	int id;
	const char* playername;

	if (!PyArg_ParseTuple(args, "s", &playername))
	{
		printf("\nError occured inside scriptsdll.getgameobjbyplayername.\n Bad argument(s)?\n");
		return NULL;
	}
	
	id = Helper::Get_ID(Get_GameObj_By_Player_Name(playername));
	return Py_BuildValue("i", id);
}

PyObject* scriptsdll_purchaseitem(PyObject *self, PyObject *args)
{
	int id, cost, boolean;

	if (!PyArg_ParseTuple(args, "ii", &id, &cost))
	{
		printf("\nError occured inside scriptsdll.purchaseitem.\n Bad argument(s)?\n");
		return NULL;
	}
	
	boolean = Purchase_Item(Commands->Find_Object(id), cost) ? 1 : 0;
	return Py_BuildValue("i", boolean);
}

PyCFunction* scriptsdll_setladderpoints(PyObject *self, PyObject *args)
{
	int playerid, amount;
	if (!PyArg_ParseTuple(args, "ii", &playerid, &amount))
	{
		printf("\nError occured inside scriptsdll.setladderpoints.\n Bad argument(s)?\n");
        return NULL;
	}
	Set_Ladder_Points(playerid, amount);
	Py_INCREF(Py_None);
	return (PyCFunction*)Py_None;
}

PyCFunction* scriptsdll_setrung(PyObject *self, PyObject *args)
{
	int playerid, amount;
	if (!PyArg_ParseTuple(args, "ii", &playerid, &amount))
	{
		printf("\nError occured inside scriptsdll.setrung.\n Bad argument(s)?\n");
        return NULL;
	}
	Set_Rung(playerid, amount);
	Py_INCREF(Py_None);
	return (PyCFunction*)Py_None;
}

PyCFunction* scriptsdll_setmoney(PyObject *self, PyObject *args)
{
	int playerid;
	float amount;

	if (!PyArg_ParseTuple(args, "if", &playerid, &amount))
	{
		printf("\nError occured inside scriptsdll.setmoney.\n Bad argument(s)?\n");
        return NULL;
	}
	Set_Money(playerid, amount);
	Py_INCREF(Py_None);
	return (PyCFunction*)Py_None;
}

PyCFunction* scriptsdll_setscore(PyObject *self, PyObject *args)
{
	int playerid;
	float amount;

	if (!PyArg_ParseTuple(args, "if", &playerid, &amount))
	{
		printf("\nError occured inside scriptsdll.setscore.\n Bad argument(s)?\n");
        return NULL;
	}
	Set_Score(playerid, amount);
	Py_INCREF(Py_None);
	return (PyCFunction*)Py_None;
}

PyObject* scriptsdll_findfirstplayer(PyObject *self, PyObject *args)
{
	int id, team;

	if (!PyArg_ParseTuple(args, "i", &team))
	{
		printf("\nError occured inside scriptsdll.findfirstplayer.\n Bad argument(s)?\n");
		return NULL;
	}
	
	id = Helper::Get_ID(Find_First_Player(team));
	return Py_BuildValue("i", id);
}

PyObject* scriptsdll_changeplayerteam(PyObject *self, PyObject *args)
{
	int boolean, id, retainmoney, retainscore, showhostmsg;

	if (!PyArg_ParseTuple(args, "iiii", &id, &retainmoney, &retainscore, &showhostmsg))
	{
		printf("\nError occured inside scriptsdll.changeplayerteam.\n Bad argument(s)?\n");
		return NULL;
	}

	boolean = Change_Player_Team(Commands->Find_Object(id), retainmoney, retainscore, showhostmsg) ? 1 : 0;
	return Py_BuildValue("i", boolean);
}

PyObject* scriptsdll_tallyteamsize(PyObject *self, PyObject *args)
{
	int count, team;

	if (!PyArg_ParseTuple(args, "i", &team))
	{
		printf("\nError occured inside scriptsdll.tallyteamsize.\n Bad argument(s)?\n");
		return NULL;
	}
	
	count = Tally_Team_Size(team);
	return Py_BuildValue("i", team);
}

PyObject* scriptsdll_getteamscore(PyObject *self, PyObject *args)
{
	int team;
	float score;

	if (!PyArg_ParseTuple(args, "i", &team))
	{
		printf("\nError occured inside scriptsdll.getteamscore.\n Bad argument(s)?\n");
		return NULL;
	}
	
	score = Get_Team_Score(team);
	return Py_BuildValue("f", score);
}

PyCFunction* scriptsdll_sendcustomallplayers(PyObject *self, PyObject *args)
{
	int message, sender, team;

	if (!PyArg_ParseTuple(args, "iii", &message, &sender, &team))
	{
		printf("\nError occured inside scriptsdll.sendcustomallplayers.\n Bad argument(s)?\n");
		return NULL;
	}
	
	Send_Custom_All_Players(message,Commands->Find_Object(sender),team);
	Py_INCREF(Py_None);
	return (PyCFunction*)Py_None;
}

PyObject* scriptsdll_stealteamcredits(PyObject *self, PyObject *args)
{
	int team;
	float theft, percentage;

	if (!PyArg_ParseTuple(args, "fi", &percentage, &team))
	{
		printf("\nError occured inside scriptsdll.stealteamcredits.\n Bad argument(s)?\n");
		return NULL;
	}
	
	theft = Steal_Team_Credits(percentage, team);
	return Py_BuildValue("f", theft);
}

PyObject* scriptsdll_getteamcredits(PyObject *self, PyObject *args)
{
	int team;
	float amount;

	if (!PyArg_ParseTuple(args, "i", &team))
	{
		printf("\nError occured inside scriptsdll.getteamcredits.\n Bad argument(s)?\n");
		return NULL;
	}
	
	amount = Get_Team_Credits(team);
	return Py_BuildValue("f", amount);
}

PyCFunction* scriptsdll_changeteam2(PyObject *self, PyObject *args)
{
	int id, team;

	if (!PyArg_ParseTuple(args, "ii", &id, &team))
	{
		printf("\nError occured inside scriptsdll.changeteam2.\n Bad argument(s)?\n");
		return NULL;
	}
	Change_Team_2(Commands->Find_Object(id), team);
	Py_INCREF(Py_None);
	return (PyCFunction*)Py_None;
}

PyObject* scriptsdll_getplayertype(PyObject *self, PyObject *args)
{
	int id, team;

	if (!PyArg_ParseTuple(args, "i", &id))
	{
		printf("\nError occured inside scriptsdll.getplayertype.\n Bad argument(s)?\n");
		return NULL;
	}
	
	team = Get_Player_Type(Commands->Find_Object(id));
	return Py_BuildValue("i", team);
}

PyObject* scriptsdll_getteamcost(PyObject *self, PyObject *args)
{
	unsigned int cost, team;
	const char* preset;

	if (!PyArg_ParseTuple(args, "sI", &preset, &team))
	{
		printf("\nError occured inside scriptsdll.getteamcost.\n Bad argument(s)?\n");
		return NULL;
	}
	
	cost = Get_Team_Cost(preset, team);
	return Py_BuildValue("I", cost);
}

PyObject* scriptsdll_getcost(PyObject *self, PyObject *args)
{
	unsigned int cost;
	const char* preset;

	if (!PyArg_ParseTuple(args, "s", &preset))
	{
		printf("\nError occured inside scriptsdll.getcost.\n Bad argument(s)?\n");
		return NULL;
	}
	
	cost = Get_Cost(preset);
	return Py_BuildValue("I", cost);
}

PyCFunction* scriptsdll_setenlisted(PyObject *self, PyObject *args)
{
	unsigned int team, position, presetid, stringid;
	const char* texture;

	if (!PyArg_ParseTuple(args, "IIIIs", &team, &position, &presetid, &stringid, &texture))
	{
		printf("\nError occured inside scriptsdll.setenlisted.\n Bad argument(s)?\n");
		return NULL;
	}
	Set_Enlisted(team, position, presetid, stringid, texture);
	Py_INCREF(Py_None);
	return (PyCFunction*)Py_None;
}

PyCFunction* scriptsdll_setbeacon(PyObject *self, PyObject *args)
{
	unsigned int team, cost, presetid, stringid;
	const char* texture;

	if (!PyArg_ParseTuple(args, "IIIIs", &team, &cost, &presetid, &stringid, &texture))
	{
		printf("\nError occured inside scriptsdll.setbeacon.\n Bad argument(s)?\n");
		return NULL;
	}
	Set_Beacon(team, cost, presetid, stringid, texture);
	Py_INCREF(Py_None);
	return (PyCFunction*)Py_None;
}

PyCFunction* scriptsdll_setrefill(PyObject *self, PyObject *args)
{
	unsigned int team, stringid;
	const char* texture;

	if (!PyArg_ParseTuple(args, "IIs", &team, &stringid, &texture))
	{
		printf("\nError occured inside scriptsdll.setrefill.\n Bad argument(s)?\n");
		return NULL;
	}
	Set_Refill(team, stringid, texture);
	Py_INCREF(Py_None);
	return (PyCFunction*)Py_None;
}

PyCFunction* scriptsdll_setpreset(PyObject *self, PyObject *args)
{
	unsigned int team, type, position, cost, presetid, stringid;
	const char* texture;

	if (!PyArg_ParseTuple(args, "IIIIIIs", &team, &type, &position, &cost, &presetid, &stringid, &texture))
	{
		printf("\nError occured inside scriptsdll.setpreset.\n Bad argument(s)?\n");
		return NULL;
	}
	Set_Preset(team, type, position, cost, presetid, stringid, texture);
	Py_INCREF(Py_None);
	return (PyCFunction*)Py_None;
}

PyCFunction* scriptsdll_setalternate(PyObject *self, PyObject *args)
{
	unsigned int team, type, position, altpos, stringid;
	const char* texture;

	if (!PyArg_ParseTuple(args, "IIIIIs", &team, &type, &position, &altpos, &stringid, &texture))
	{
		printf("\nError occured inside scriptsdll.setalternate.\n Bad argument(s)?\n");
		return NULL;
	}
	Set_Alternate(team, type, position, altpos, stringid, texture);
	Py_INCREF(Py_None);
	return (PyCFunction*)Py_None;
}